#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    long long x, y;
    int index;
} Vektor;

typedef struct {
    long long dist_sq;
    int k;
    int *indeksi;
} Rezultat;

void oslobodi_rezultat(Rezultat *r) {
    if (r->indeksi != NULL) {
        free(r->indeksi);
    }
}

Rezultat Izracunaj(int N, Vektor vektori[], int (*predikat)(long long, long long)) {
    Rezultat rez = {0, 0, NULL};
    long long Rx = 0;
    long long Ry = 0;
    
    int *trenutni_indeksi = (int *)malloc(N * sizeof(int));
    if (trenutni_indeksi == NULL) return rez;

    int trenutni_k = 0;
    
    for (int i = 0; i < N; i++) {
        long long xi = vektori[i].x;
        long long yi = vektori[i].y;

        if (predikat(xi, yi)) {
            Rx += xi;
            Ry += yi;
            trenutni_indeksi[trenutni_k++] = vektori[i].index;
        }
    }

    rez.dist_sq = Rx * Rx + Ry * Ry;
    rez.k = trenutni_k;
    
    if (trenutni_k > 0) {
        rez.indeksi = (int *)malloc(trenutni_k * sizeof(int));
        if (rez.indeksi != NULL) {
            memcpy(rez.indeksi, trenutni_indeksi, trenutni_k * sizeof(int));
        } else {
             rez.k = 0;
        }
    }
    
    free(trenutni_indeksi);
    return rez;
}

int predikat_x_plus(long long x, long long y) { return x > 0; }
int predikat_x_minus(long long x, long long y) { return x < 0; }
int predikat_y_plus(long long x, long long y) { return y > 0; }
int predikat_y_minus(long long x, long long y) { return y < 0; }
int predikat_sum_plus(long long x, long long y) { return x + y > 0; }
int predikat_sum_minus(long long x, long long y) { return x + y < 0; }
int predikat_raz_plus(long long x, long long y) { return x - y > 0; }
int predikat_raz_minus(long long x, long long y) { return x - y < 0; }

int main() {
    int N;
    if (scanf("%d", &N) != 1 || N < 1) return 1;

    Vektor *vektori = (Vektor *)malloc(N * sizeof(Vektor));
    if (vektori == NULL) return 1;

    for (int i = 0; i < N; i++) {
        if (scanf("%lld %lld", &vektori[i].x, &vektori[i].y) != 2) {
             free(vektori);
             return 1;
        }
        vektori[i].index = i + 1;
    }

    int (*predikati[])(long long, long long) = {
        predikat_x_plus, predikat_x_minus, predikat_y_plus, predikat_y_minus,
        predikat_sum_plus, predikat_sum_minus, predikat_raz_plus, predikat_raz_minus
    };
    const int NUM_TESTS = 8;
    
    Rezultat najbolji_rez = {0, 0, NULL};

    for (int i = 0; i < NUM_TESTS; i++) {
        Rezultat trenutni_rez = Izracunaj(N, vektori, predikati[i]);
        
        if (trenutni_rez.dist_sq > najbolji_rez.dist_sq) {
            oslobodi_rezultat(&najbolji_rez);
            najbolji_rez = trenutni_rez;
        } else {
            oslobodi_rezultat(&trenutni_rez);
        }
    }

    printf("%d\n", najbolji_rez.k);
    if (najbolji_rez.k > 0) {
        for (int i = 0; i < najbolji_rez.k; i++) {
            printf("%d%s", najbolji_rez.indeksi[i], (i == najbolji_rez.k - 1) ? "" : " ");
        }
        printf("\n");
    }

    oslobodi_rezultat(&najbolji_rez);
    free(vektori);

    return 0;
}